// Gra w zycieDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Gra w zycie.h"
#include "Gra w zycieDlg.h"
#include "Gra.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CGrawzycieDlg dialog




CGrawzycieDlg::CGrawzycieDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CGrawzycieDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CGrawzycieDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_PICTURECONTROL1, pictureControl1);
	DDX_Control(pDX, IDC_EDIT1, editControl1);
	DDX_Control(pDX, IDC_EDIT2, editControl2);
}

BEGIN_MESSAGE_MAP(CGrawzycieDlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BUTTON1, &CGrawzycieDlg::OnBnClickedButton1)
	ON_WM_NCCALCSIZE()
	ON_BN_CLICKED(IDC_BUTTON2, &CGrawzycieDlg::OnBnClickedButton2)
END_MESSAGE_MAP()


// CGrawzycieDlg message handlers

BOOL CGrawzycieDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	rozmiar = 100;
	komorki1 = new char[rozmiar * rozmiar];
	komorki2 = new char[rozmiar * rozmiar];
	biezaceKomorki = komorki1;
	OnBnClickedButton2();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CGrawzycieDlg::OnPaint()
{
	rysujKomorki();
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CGrawzycieDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CGrawzycieDlg::OnNcCalcSize(BOOL bCalcValidRects, NCCALCSIZE_PARAMS* lpncsp)
{
	CRect rect;
	int dx, dy;

	if (lpncsp->rgrc[0].right == lpncsp->rgrc[1].right)
		dx = lpncsp->rgrc[1].left - lpncsp->rgrc[0].left;
	else
		dx = lpncsp->rgrc[0].right - lpncsp->rgrc[1].right;

	if (lpncsp->rgrc[0].bottom == lpncsp->rgrc[1].bottom)
		dy = lpncsp->rgrc[1].top - lpncsp->rgrc[0].top;
	else
		dy = lpncsp->rgrc[0].bottom - lpncsp->rgrc[1].bottom;
	::GetWindowRect(pictureControl1, &rect);
	::SetWindowPos(pictureControl1, NULL, 0, 0, rect.Width() + dx, rect.Height() + dy, SWP_NOMOVE);
	
	CDialog::OnNcCalcSize(bCalcValidRects, lpncsp);
}

void CGrawzycieDlg::rysujKomorki() {
	pictureControl1.Invalidate();

	CPaintDC dc(&pictureControl1);
	CRect rect;
	int dx, dy;

	pictureControl1.GetWindowRect(&rect);
	dx = rect.Width() / rozmiar;
	dy = rect.Height() / rozmiar;

	dc.FillSolidRect(0, 0, rect.Width(), rect.Height(), 0xA0A0A0);
	for (int i = 0; i < rozmiar; ++i) {
		for (int j = 0; j < rozmiar; ++j) {
			if (biezaceKomorki[i * rozmiar + j] != 0)
				dc.FillSolidRect(i * dx, j * dy, dx, dy, 0x00AA00);
			else
				dc.FillSolidRect(i * dx, j * dy, dx, dy, 0xFFFFFF);
		}
	}
}

void CGrawzycieDlg::OnBnClickedButton1()
{
	char* poprzednieKomorki = (biezaceKomorki == komorki1) ? komorki2 : komorki1;
	double czas;
	int ilosc;

	kolejnePokolenie(biezaceKomorki, poprzednieKomorki, rozmiar, czas, ilosc);
	biezaceKomorki = poprzednieKomorki;

	CString czasStr;
	czasStr.Format(_T("Czas: %g"), czas);
	editControl1.SetWindowTextW(czasStr);

	CString iloscStr;
	iloscStr.Format(_T("Ilo komrek: %d"), ilosc);
	editControl2.SetWindowTextW(iloscStr);

	rysujKomorki();
}

void CGrawzycieDlg::OnBnClickedButton2()
{
	srand(time(NULL));
	for (int i = 0; i < rozmiar * rozmiar; ++i)
		biezaceKomorki[i] = rand() % 2;
	rysujKomorki();
}
